import "dotenv/config";

const API_BASE = process.env.REAL_API_BASE || "https://api.realruntime.com";
const API_KEY = process.env.REAL_API_KEY || "";
const REAL_SCOPE = process.env.REAL_SCOPE || "realflow:stream";

async function verify() {
  if (!API_KEY) {
    throw new Error("Missing REAL_API_KEY in environment");
  }

  const res = await fetch(`${API_BASE}/v1/auth/verify`, {
    method: "POST",
    headers: { "content-type": "application/json" },
    body: JSON.stringify({
      api_key: API_KEY,
      required_scope: REAL_SCOPE,
      consume: false,
    }),
  });

  const data = await res.json();
  if (!res.ok) {
    throw new Error(`Verify request failed: ${res.status}`);
  }
  return data;
}

async function pingRealFlow() {
  const res = await fetch(`${API_BASE}/v1/demo/realflow/ping`, {
    headers: {
      Authorization: `Bearer ${API_KEY}`,
    },
  });
  const data = await res.json();
  return { status: res.status, data };
}

async function main() {
  const verifyResult = await verify();
  console.log("verify:", verifyResult);

  const pingResult = await pingRealFlow();
  console.log("realflow ping:", pingResult);
}

main().catch((err) => {
  console.error(err.message || err);
  process.exit(1);
});
