#!/usr/bin/env bash
set -euo pipefail

ROOT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$ROOT_DIR"

if [ ! -d ".venv" ]; then
  python3 -m venv .venv
fi

if [ -f ".env" ]; then
  set -a
  # shellcheck source=/dev/null
  source ".env"
  set +a
fi

source .venv/bin/activate
pip install -r requirements.txt

HOST="${DEMO_HOST:-127.0.0.1}"
PORT="${DEMO_PORT:-8787}"

uvicorn backend.main:app --host "$HOST" --port "$PORT" --reload
