# RealRuntime x Gemini Realtime Demo

Branded reference example that shows how to:

1. Verify a scoped RealRuntime API key.
2. Gate realtime message flow through RealRuntime entitlement checks.
3. Forward the message to Gemini with emotional guidance controls.

The demo includes a FastAPI backend and a product-branded frontend.

## Architecture

Client path:

`Browser UI -> /v1/session/check or /v1/chat/respond -> RealRuntime /v1/auth/verify -> Gemini generateContent`

Key design choice:

- RealRuntime stays in front of provider inference so entitlement, scope, and usage policy are enforced first.

## Prerequisites

- Python 3.10+
- A running RealRuntime API (default: `http://127.0.0.1:8090`)
- A Gemini API key

## Quick Start

```bash
cd examples/gemini_realtime_demo
cp .env.example .env
./run.sh
```

Open:

- `http://127.0.0.1:8787/`

Hosted Render reference:

- `https://realruntime-live-demo.onrender.com/`

## Environment

Use `.env` to override defaults:

- `REALRUNTIME_API_BASE`
- `REALRUNTIME_REQUIRED_SCOPE`
- `GEMINI_API_BASE`
- `GEMINI_MODEL`
- `GEMINI_API_KEY`
- `DEMO_HOST`
- `DEMO_PORT`
- `DEMO_CORS_ALLOW_ORIGINS`
- `DEMO_MAX_REQUEST_BODY_BYTES`

## API Routes in this Demo

- `GET /health` -> demo health check
- `GET /v1/config` -> frontend defaults from environment
- `POST /v1/session/check` -> verifies RealRuntime key + required scope
- `POST /v1/chat/respond` -> verify + Gemini response generation

## Notes

- The frontend stores non-secret config in `localStorage`.
- API keys are stored in `sessionStorage` for demo convenience only.
- For production, move secrets to secure backend storage and hardened auth flows.
- Demo backend applies baseline security headers, body-size limits, and restricted CORS.
